implementation module deltaEventIO


import ioTypes, Events
from    Menu0   import InitMenu
from    Window1 import InitWindows
from    Timer1  import InitTimers
from clCrossCall import Iprint
import  Dialog1

:: InitialIO *s :== [s ->  *((IOState s) -> (s, IOState s)) ]


/*	StartIO starts a new interaction specified by the IOSystem argument.
	Of each device only the first occurrence is taken into account. The
	program state argument serves as initial program state. The first
	functions to be evaluated are given in InitialIO from left-to-right.
	StartIO returns the final program state and the resulting events.
	In this version the program state must be unique. */

StartIO :: !(IOSystem *s (IOState *s)) !*s !(InitialIO *s) !*World -> (!*s, !*World)
StartIO []   s _     world = (s, world)
StartIO defs s inits world = (finals, worldN)
where

//  Initialize IOState
	(events, world1)           =  OpenEvents world
	os				           =  EventsToOs events
	os1                        =  WinStartOsThread os
	ioadmin                    =  EmptyIOadmin
	defs2                      =  HandleAboutBox defs
	(ioadmin2, os2)	 	       =  InitMenu defs2 ioadmin os1
	(ioadmin3, os3)		       =  InitWindows defs2 ioadmin2 os2
    (ioadmin4, os4)            =  InitDialogs defs2 ioadmin3 os3 
	(firstIOadmin, firstOs )   =  InitTimers defs2 ioadmin4 os4
	firstIOstate               =  IOStateSetWorld world1 (PackIOState firstIOadmin firstOs)
	(initials, initialIOState) =  DoInitialIO inits s firstIOstate  

	DoInitialIO :: (InitialIO *s) *s (IOState *s) -> (*s, IOState *s)
	DoInitialIO []         s io  =  (s, io)
	DoInitialIO [ f : fs ] s io  =  DoInitialIO fs s` io`
	where
		(s`,io`)  = f s io

	( initialadmin, initialos ) =  UnpackIOState initialIOState

//  Do events 'till quitIO was called

	(finals, doneadmin, doneos)  =  DoMessageLoop initials initialadmin initialos 

//  Final clean up
	(world2, finalIOState)  =  IOStateGetWorld (PackIOState doneadmin doneos)
	( finaladmin, finalos ) =  UnpackIOState finalIOState
	
	worldN       =  CloseEvents (OsToEvents finalos) world2

/*	QuitIO closes all devices that are held in the IOState argument.
	The resulting (empty) IOState will cause StartIO to terminate. QuitIO
	is the only function which terminates StartIO. */

QuitIO :: !(IOState s) -> IOState s
QuitIO iostate = PackIOState newadmin newos
where
	( admin, os)	=  UnpackIOStateWithCheck iostate
	newadmin		=  { admin & io_quit = True }
	newos           =  WinKillOsThread os


/*	ChangeIOState applies the functions in its first argument in
	consecutive order to the second (IOState) argument. */

ChangeIOState :: ![(IOState s) -> (IOState s)] !(IOState s) -> IOState s
ChangeIOState [] io = io
ChangeIOState [f:fs] io = ChangeIOState fs (f io)


HandleAboutBox :: !(IOSystem *s (IOState *s)) -> !IOSystem *s (IOState *s)
HandleAboutBox iosys 
  = case GetAboutDlog iosys of
     Nope  -> iosys
	 OK ad -> AddToMenuSystem ad iosys
where  
  GetAboutDlog [] = Nope
  GetAboutDlog [ DialogSystem dlogs : rest ] = GetAbout` dlogs
  GetAboutDlog [ other : rest ] = GetAboutDlog rest

  GetAbout` [] = Nope
  GetAbout` [ ad=:(AboutDialog _ _ _ _) : rest ] = OK ad
  GetAbout` [ other : rest ] = GetAbout` rest

  AddToMenuSystem ad [] = []
  AddToMenuSystem ad [ MenuSystem menus : rest ] = [ MenuSystem (menus ++ helpmenu) : rest ]
  where helpmenu = [ AboutBox2HelpMenu ad ]
  AddToMenuSystem ad [ other : rest ] = [ other : AddToMenuSystem ad rest ]

  AboutBox2HelpMenu (AboutDialog name domain drawfunctions helpdef)
    =  PullDownMenu (-1) "Help" Able (helpelements ++ aboutelement)
  where
    helpelements = case helpdef of 
	                 NoHelp  -> []
					 AboutHelp title function 
					         -> [ MenuItem (-2) title NoKey Able function,
							      MenuSeparator ]
	aboutelement = [ MenuItem (-3) aboutname NoKey Able dodialogfunction ]

    aboutname = "About " +++ name

	dodialogfunction s io = OpenModalDialog dialog s io

	dialog = CommandDialog (-1) aboutname [] (-2) items

	items  = [ Control (-3) Center domain Unable  (ListCS []) look feel funct,
	           DialogButton (-2) Center "OK" Able closef
			 ]
	look _ _  = drawfunctions
	feel _ cs = (cs, drawfunctions)
    funct di ds = ds
	closef di s io = (s, CloseDialog (-1) io)
